// ignore_for_file: deprecated_member_use

import 'dart:async';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/splashScreenApi.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Repository/DeviceInfo.dart';
import 'package:absenkuv3/UI/Template/dialog/dialogUpdateApp.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:url_launcher/url_launcher.dart';
import 'package:absenkuv3/Repository/Model/mDeviceInfo.dart';
import 'NavigatorBloc.dart';

abstract class SplashScreenEvent {
  BuildContext? context;
}

class InitStateEvent extends SplashScreenEvent {
  InitStateEvent(BuildContext _context) {
    context = _context;
  }
}

class VersionAppEvent extends SplashScreenEvent {
  VersionAppEvent(BuildContext _context) {
    context = _context;
  }
}

class SplashScreenBloc extends Bloc<SplashScreenEvent, String?> {
  SplashScreenBloc() : super(null);

  @override
  Stream<String> mapEventToState(SplashScreenEvent event) async* {
    if (event is InitStateEvent) {
      LoginRespon? data = await sharedPreferences().getUserData();
      MDeviceinfo mDeviceInfo = await DeviceInfo().getDeviceInfo();
      // print("DEVICE ID ${mDeviceInfo.deviceId}");
      int versiMobile = ServerInfo.versionCode;
      // var data;
      // print("init splash");
      // Timer(Duration(seconds: 2), () async{
      // print("cek update..."+versiMobile.toString());
      VersionRespon versionRespon =
          await SplashScreenApi().cekVersion(versiMobile, mDeviceInfo.os);
      if (versionRespon.success!) {
        // UPDATE APK
        showDialog(
          barrierDismissible: false,
          context: event.context!,
          builder: (BuildContext context) => DialogUpdateApp(
            data: versionRespon,
            onClick: () {
              // print("update");
              launcherUrl(versionRespon.version!.linkUpdate!);
            },
            onClickSkip: () {
              if (data.dataLogin != null)
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateRemoveToDashboard(event.context));
              else
                // BlocProvider.of<NavigatorBloc>(event.context!)
                //     .add(NavigateRemoveToLogin(event.context));
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateRemoveToLoginSSO(event.context));
            },
          ),
        );
      } else {
        if (data.dataLogin != null)
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigateRemoveToDashboard(event.context));
        else
          // BlocProvider.of<NavigatorBloc>(event.context!)
          //     .add(NavigateRemoveToLogin(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateRemoveToLoginSSO(event.context));
      }
      // });
    } else if (event is VersionAppEvent) {
      String versiMobile = ServerInfo.versionName;
      BasicRespon versionRespon =
          await SplashScreenApi().versionApp(versiMobile);
      debugPrint(versionRespon.message);
    }
  }

  launcherUrl(String link) async {
    // if (await canLaunch(link)) {
      await launch(link);
    // } else {
    //   throw 'Could not launch $link';
    // }
  }
}
